#ifndef _Command_CPP
#define _Command_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SqlExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"

#include "../../SharedClasses/SQLClass/SQLClass.H"
#include "../../SharedClasses/SQLClass/SQLRoutines.H"

#include "../SockServer/SockServer.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "SQLImport.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SendNextStatement(SocketServer *pSockSrvr, int iClient);
bool ReceiveFileData(SocketServer *pSockSrvr, int iClient, char *sFileName);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int ProcessCommand(SocketServer *pSockSrvr, int iClient, char *sRecvBuf, int iRecvBufSz);

	Processes a command from the peer.

	Possible return Values:
		CMD_OK    The command was a success, all is well.
		CMD_DONE  The command was a success, close the connection.
		CMD_ERROR The command failed due to an error.
*/
int ProcessCommand(SocketServer *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[RECEIVEBUFSZ + 1];
    //char sRecvBuf[RECEIVEBUFSZ + 1];
    //char sSendBuf[MAXSENDBUFSZ + 1];

	//int iRecvBufSz = 0;
	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

    if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendFirstSQL")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Client is requesting first SQL string.");

        char sSQL[255];
        sprintf(sSQL, "SELECT Statement, ImportTable FROM WP_Statements WHERE Active = 1 ORDER BY Sequence");

        if(CCI[iClient].CustDB.DBExecute(sSQL, &CCI[iClient].hStatementHandle))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Successfully executed FirstSQL statement.");
		}
		else{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to executed FirstSQL statement.");
			return CMD_ERROR;
		}

        int iSendResult = SendNextStatement(pSockSrvr, iClient);
        if(iSendResult == SENDNEXTSTATEMENT_FAILURE){
            WriteLog(pSockSrvr->icClientID[iClient], "Failed to send first statement.");
            return CMD_ERROR;
        }
        else if(iSendResult == SENDNEXTSTATEMENT_DONE){
            WriteLog(pSockSrvr->icClientID[iClient], "End of statements.");
            pSockSrvr->SetNextSendData(iClient, "::EndOfStatements");
            return CMD_OK;
        }

		WriteLog(pSockSrvr->icClientID[iClient], "Successfully sent first SQL statement.");

			//sprintf(sSendBuf, "::SQL->%s", "select * from salesOrd");
		//pSockSrvr->SetNextSendData(iClient, sSendBuf);

		return CMD_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendNextSQL")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Client is requesting next SQL string.");

        int iSendResult = SendNextStatement(pSockSrvr, iClient);
        if(iSendResult == SENDNEXTSTATEMENT_FAILURE){
            WriteLog(pSockSrvr->icClientID[iClient], "Failed to send next statement.");
            return CMD_ERROR;
        }
        else if(iSendResult == SENDNEXTSTATEMENT_DONE){
            WriteLog(pSockSrvr->icClientID[iClient], "End of statements.");
            pSockSrvr->SetNextSendData(iClient, "::EndOfStatements");
            return CMD_OK;
        }

		WriteLog(pSockSrvr->icClientID[iClient], "Successfully sent next SQL statement.");

		return CMD_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SendingFileData->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		WriteLog(pSockSrvr->icClientID[iClient], "Client sending file data.");

        sprintf(CCI[iClient].sFileName, "%s\\%s\\%s.wpd", sImportTempDir, CCI[iClient].sCompanyName, sCmdData);
        CreateFolderStructure(CCI[iClient].sFileName);

		ReceiveFileData(pSockSrvr, iClient, CCI[iClient].sFileName);

		//if(ImportSQLResults(pSockSrvr, iClient, "C:\\Orig SalesOrd.wpd")) // Debug Code
		if(ImportSQLResults(pSockSrvr, iClient, CCI[iClient].sFileName))
        {
			pSockSrvr->SetNextSendData(iClient, "::LastImportSuccess");
            return CMD_OK;
        }
        else{
            // FIXME: Should we return CMD_OK or CMD_ERROR
			pSockSrvr->SetNextSendData(iClient, "::LastImportFailed");
            return CMD_OK;
        }

		return CMD_OK;
	}

	return CMD_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReceiveFileData(SocketServer *pSockSrvr, int iClient, char *sFileName)
{
    FILE *hTargetHandle = NULL;

    char sRecvBuf[MAXRECVSIZE + 1];
    int iRecvBufSz = 0;

	DWORD dwDataCRC = 0xffffffff;

	WriteLog(pSockSrvr->icClientID[iClient], "Begining file transfer.");

	if( (hTargetHandle = fopen(sFileName, "wb")) == NULL)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Failed to open export file for binary write.");
        return false;
    }

    while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
    {
        if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
        {
			if(iRecvBufSz == 5)
			{
				sRecvBuf[iRecvBufSz] = '\0';
				if(strcmp(sRecvBuf, "::EOF") == 0)
				{
					break;
				}
			}

			fwrite(sRecvBuf, sizeof(char), iRecvBufSz, hTargetHandle);
		}
		else Sleep(1);
	}

	fclose(hTargetHandle);

	if(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
	{
		return true;
	}
	else return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SendNextStatement(SocketServer *pSockSrvr, int iClient)
{
    SQLINTEGER StatementLen = 0;
    SQLCHAR Statement[1024 + 1];
    SQLINTEGER ImportTableLen = 0;
    SQLCHAR ImportTable[32 + 1];

    char SendData[MAXSENDBUFSZ + 1];

    if(!DBFetch(CCI[iClient].hStatementHandle))
    {
        // This is not an error. It means there are no more rows.
        DBCloseCursor(CCI[iClient].hStatementHandle);
        CCI[iClient].hStatementHandle = NULL;
        return SENDNEXTSTATEMENT_DONE;
    }

    if(!DBGetData(CCI[iClient].hStatementHandle, 1, SQL_C_CHAR, Statement, 1024, &StatementLen))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "DBGetData Statement error.");

        DBCloseCursor(CCI[iClient].hStatementHandle);
        return SENDNEXTSTATEMENT_FAILURE;
    }

	if(StatementLen == -1)
	{
	    DBCloseCursor(CCI[iClient].hStatementHandle);
		return SENDNEXTSTATEMENT_FAILURE;
	}

    if(!DBGetData(CCI[iClient].hStatementHandle, 2, SQL_C_CHAR, ImportTable, 32, &ImportTableLen))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "DBGetData ImportTable error.");

        DBCloseCursor(CCI[iClient].hStatementHandle);
        return SENDNEXTSTATEMENT_FAILURE;
    }

	//If the ImportTable is not NULL send it over to the client.
	if(ImportTableLen != -1)
	{
		sprintf(SendData, "::ImportTable->%s", ImportTable);
		if(!pSockSrvr->SetNextSendData(iClient, SendData))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to send ImportTable.");
			return SENDNEXTSTATEMENT_FAILURE;
		}
	}

    sprintf(SendData, "::SQL->%s", Statement);
    if(!pSockSrvr->SetNextSendData(iClient, SendData))
	{
		WriteLog(pSockSrvr->icClientID[iClient], "Failed to send SQL string.");
		return SENDNEXTSTATEMENT_FAILURE;
	}

    return SENDNEXTSTATEMENT_SUCCESS;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
